/* - ANAttachListener -
 * populate the fields and controls
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.AnalogPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;
import javax.swing.JCheckBox;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ANAttachListener implements AttachListener {

    private JFrame appFrame;
    private JPanel channelPanel;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numChannelsTxt;
    private JCheckBox enabledArray[];
    private JSlider voltageSliderArray[];
    private JTextField voltageTxtArray[];

    public ANAttachListener(JFrame appFrame, JPanel channelPanel, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numChannelsTxt, JCheckBox enabledArray[], JSlider voltageSliderArray[],
            JTextField voltageTxtArray[]) {
        this.appFrame = appFrame;
        this.channelPanel = channelPanel;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numChannelsTxt = numChannelsTxt;
        this.enabledArray = enabledArray;
        this.voltageSliderArray = voltageSliderArray;
        this.voltageTxtArray = voltageTxtArray;
    }

    public void attached(AttachEvent an) {
        try {
            int i;
            appFrame.setSize(357, 500);

            AnalogPhidget attached = (AnalogPhidget) an.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numChannelsTxt.setText(Integer.toString(attached.getOutputCount()));

            channelPanel.setEnabled(true);
            channelPanel.setVisible(true);

            for (i = 0; i < attached.getOutputCount(); i++) {

                enabledArray[i].setEnabled(true);
                enabledArray[i].setVisible(true);
                enabledArray[i].setSelected(attached.getEnabled(i));

                voltageSliderArray[i].setEnabled(true);
                voltageSliderArray[i].setVisible(true);
                voltageSliderArray[i].setMaximum((int) Math.floor(attached.getVoltageMax(i) * 100));
                voltageSliderArray[i].setMinimum((int) Math.ceil(attached.getVoltageMin(i)) * 100);
                voltageSliderArray[i].setValue((int) attached.getVoltage(i));

                voltageTxtArray[i].setEnabled(true);
                voltageTxtArray[i].setVisible(true);
                voltageTxtArray[i].setText(Double.toString(attached.getVoltage(i)));
            }

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
}
